/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.pokemon;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.PokemonStats;
import java.util.List;
import java.util.Map;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import net.minecraft.class_7923;

public class CobblemonPokemonParser {
    public ShowdownPokemon toShowdownPokemon(Pokemon pokemon) {
        return new ShowdownPokemon(this.getNickName(pokemon), pokemon.getSpecies().getResourceIdentifier().toString(), pokemon.getForm().getName(), pokemon.getShiny(), class_7923.field_41178.method_10221((Object)pokemon.heldItem().method_7909()).toString(), pokemon.getAbility().getName(), this.toShowdownGender(pokemon.getGender()), pokemon.getNature().getName().toString(), pokemon.getLevel(), this.toShowdownStats((PokemonStats)pokemon.getEvs()), this.toShowdownStats((PokemonStats)pokemon.getIvs()), this.toShowdownMoveSet(pokemon.getMoveSet()));
    }

    private String getNickName(Pokemon pokemon) {
        try {
            return pokemon.getNickname().getString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private String toShowdownGender(Gender gender) {
        return switch (gender) {
            default -> throw new MatchException(null, null);
            case Gender.MALE -> "M";
            case Gender.FEMALE -> "F";
            case Gender.GENDERLESS -> "";
        };
    }

    private Map<String, Integer> toShowdownStats(PokemonStats cobblemonStats) {
        return Map.of("hp", cobblemonStats.getOrDefault((Stat)Stats.HP), "atk", cobblemonStats.getOrDefault((Stat)Stats.ATTACK), "def", cobblemonStats.getOrDefault((Stat)Stats.DEFENCE), "spa", cobblemonStats.getOrDefault((Stat)Stats.SPECIAL_ATTACK), "spd", cobblemonStats.getOrDefault((Stat)Stats.SPECIAL_DEFENCE), "spe", cobblemonStats.getOrDefault((Stat)Stats.SPEED));
    }

    private List<String> toShowdownMoveSet(MoveSet cobblemonMoveSet) {
        return cobblemonMoveSet.getMoves().stream().map(Move::getName).toList();
    }
}

